import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { LegalEntity } from "./legal-entity";

export class Source {

    @ApiProperty({
        description: 'PID of trusted source (REQUIRED)',
    })
    pid: string;

    @ApiProperty({
        description: 'Contact information of legal entity (REQUIRED)',
    })
    descriptor: LegalEntity;

    @ApiProperty({
        description: 'ISO8601 timestamp of onboarding (REQUIRED)',
    })
    in: string;

    @ApiPropertyOptional({
        description: 'ISO8601 timestamp of offboarding, when applicable (OPTIONAL)',
    })
    out?: string;
}