import { ApiProperty } from "@nestjs/swagger";

export class TransactionResult {

    @ApiProperty({
        description: 'Marketplace transaction ID (UUID v4)',
        example: 'f81d4fae-7dec-11d0-a765-00a0c91e6bf6'
    })
    marketplace_transaction_id: string;

    @ApiProperty({
        description: 'Timestamp of the transaction in ISO8601 format',
        example: '2025-12-02T14:30:00.000Z'
    })
    timestamp: string;
}
