import { ApiPropertyOptional } from '@nestjs/swagger';
import { PaginationParams } from './pagination-params';

/* Like UserQuelifiedId but with no validity rules */
export class UserBlacklistFilter extends PaginationParams {

    @ApiPropertyOptional({
        description: `DID of the user's Onboarding Authority`,
    })
    oa?: string;

    @ApiPropertyOptional({
        description: `UID of the user, as assigned by its Onboarding Authority`,
    })
    uid?: string;
}