import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, IsEnum, ValidateNested } from 'class-validator';
import { ListOperation } from '../constants';
import { UserQualifiedId } from './user-qualified-id';
import { Type } from 'class-transformer';

export class UserBlacklistOp {

    @ApiProperty({
        description: `Reference to the target user`,
    })
    @IsNotEmpty()
    @Type(() => UserQualifiedId)
    @ValidateNested()
    target: UserQualifiedId;

    @ApiProperty({
        description: `Operation to be performed on the blacklist (accepted values: [${Object.values(ListOperation).join(', ')}])`,
    })
    @IsNotEmpty()
    @IsEnum(ListOperation)
    operation: ListOperation;
}