import { ApiProperty } from '@nestjs/swagger';
import { IsNotEmpty, IsString, Length } from 'class-validator';
import { TEXTCOL_MAXL } from '../constants';

export class UserQualifiedId {

    @ApiProperty({
        description: `DID of the user's Onboarding Authority`,
    })
    @IsNotEmpty()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    oa: string;

    @ApiProperty({
        description: `UID of the user, as assigned by its Onboarding Authority`,
    })
    @IsNotEmpty()
    @IsString()
    @Length(1, TEXTCOL_MAXL)
    uid: string;
}