import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { UserRole } from '../constants';

export class UserRef {

    @ApiProperty({
        description: `User ID`,
    })
    uid: string;

    @ApiProperty({
        description: `Role assigned`,
        enum: UserRole,
    })
    role: UserRole;

    @ApiPropertyOptional({
        description: `Affiliation PID`,
    })
    affiliation?: string;

    @ApiProperty({
        description: `Last name`,
    })
    lastName: string;

    @ApiProperty({
        description: 'True if user has ONBOARDED status, false otherwise',
    })
    active: boolean;
}