import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';
import { UserRole } from '../constants';

export class User {

    @ApiProperty({
        description: `User ID`,
    })
    uid: string;

    @ApiProperty({
        description: `Invitation ID`,
    })
    iid: string;

    @ApiProperty({
        description: `Date of invitation (ISO8601)`,
    })
    invited: string;

    @ApiProperty({
        description: `OTP for claiming the onboarding credential`,
    })
    otp: string;

    @ApiProperty({
        description: `Number of attempts at claiming the onboarding credential`,
    })
    otpAttempts: number;

    @ApiProperty({
        description: `Role assigned`,
        enum: UserRole,
    })
    role: UserRole;

    @ApiPropertyOptional({
        description: `Country of residence`,
    })
    country?: string;

    @ApiPropertyOptional({
        description: `Affiliation PID`,
    })
    affiliation?: string;

    @ApiPropertyOptional({
        description: `Nickame`,
    })
    nickname?: string;

    @ApiProperty({
        description: `First name`,
    })
    firstName: string;

    @ApiProperty({
        description: `Last name`,
    })
    lastName: string;

    @ApiProperty({
        description: `Email`,
    })
    email: string;

    @ApiPropertyOptional({
        description: `Phone number`,
    })
    phone?: string;

    @ApiPropertyOptional({
        description: 'Date of onboarding, if applicable (ISO8601)',
    })
    onboarded?: string;

    @ApiPropertyOptional({
        description: 'Data of offboarding, if applicable (ISO8601)',
    })
    offboarded?: string;
}