import { Injectable } from '@nestjs/common';
import * as nodemailer from 'nodemailer';
import Mail = require('nodemailer/lib/mailer');

@Injectable()
export class EmailService {

    private transporter: nodemailer.Transporter;

    constructor() {
        this.transporter = nodemailer.createTransport({
            service: 'gmail',
            auth: {
                user: process.env.GMAIL_USER,
                pass: process.env.GMAIL_PASS
            },
        });
    }

    async sendMail(to: string, subject: string, text: string): Promise<void> {
        const mailOptions = {
            from: process.env.GMAIL_USER,
            to,
            subject,
            text,
        };

        await this.transporter.sendMail(mailOptions);
    }

    async sendHtmlMail(to: string, subject: string, html: string, attachments?: Mail.Attachment[]): Promise<void> {
        const mailOptions = {
            from: process.env.GMAIL_USER,
            to,
            subject,
            html,
            attachments,
        };

        await this.transporter.sendMail(mailOptions);
    }
}
