import {
    Body,
    Controller,
    Logger,
    Post
} from '@nestjs/common';
import { MembershipService } from './membership-service';
import { translateToHttpException } from 'src/utils';
import { MachineIdentityRequest } from 'src/dtos/machine-identity-request';

// ONLY ENABLE (IN THE MODULE CLASS) FOR THE TIME NEEDED TO ACHIEVE THE GOAL, DISABLE ASAP.
@Controller('/api/v1.0/backdoors')
export class MembershipControllerOpen {

    constructor(
        private readonly membership: MembershipService
    ) { }

    // Creates a new machine identity.
    // This is an undocumented "emergency backdoor" endpoint to create machine identities in case
    // the system manager(s) lose access to their legitimate credentials.
    @Post('/machine-identities')
    async createMachineIdentity(@Body() req: MachineIdentityRequest): Promise<string> {
        Logger.log('Requesting new machine identity: ' + JSON.stringify(req));
        try {
            return await this.membership.createMachineIdentity(req.affiliation, req.role, req.region);
        } catch (err) {
            translateToHttpException(err);
        }
    }
}
