import { Module } from '@nestjs/common';
import { MembershipController } from './membership-controller';
import { MembershipService } from './membership-service';
import { MembershipControllerInternal } from './membership-controller-internal';
import { ProcessState } from '../integration/process-state';
import { BackgroundJobState } from '../integration/background-job-state';
import { BackgroundJobNotifier } from '../integration/background-job-notifier';
import { EmailService } from '../integration/email-service';
import { BlacklistService } from './blacklist-service';
import { TypeOrmModule } from '@nestjs/typeorm';
import { AccountEntity, AuthorityEntity, MemberEntity, TransactionEntity } from './membership-entities';
import { BlacklistAuthorityEntity, BlacklistMemberEntity, BlacklistUserEntity } from './blacklist-entities';
import { MembershipStorage } from './membership-storage';
import { BlacklistStorage } from './blacklist-storage';
//import { MembershipControllerOpen } from './membership-controller-open';

@Module({
    imports: [
        TypeOrmModule.forFeature([
            MemberEntity,
            AuthorityEntity,
            AccountEntity,
            TransactionEntity,
            BlacklistUserEntity,
            BlacklistMemberEntity,
            BlacklistAuthorityEntity
        ])
    ],
    controllers: MembershipModule.getControllers(),
    providers: [MembershipService, BlacklistService, ProcessState, BackgroundJobState, BackgroundJobNotifier, EmailService, MembershipStorage, BlacklistStorage],
    exports: [MembershipService], // for direct use in OA and stats
})
export class MembershipModule {
    static getControllers(): Array<any> {
        
        const controllersInternal: Array<any> = [
            // add all the controllers that are only for internal use
            MembershipControllerInternal,
        ];

        const controllers: Array<any> = [
            // add all the controllers that are for external use
            MembershipController,
            //MembershipControllerOpen // emergency backdoor, only enabled when needed
        ];

        if (process.env?.INTERNAL_API?.trim() === 'true')
            return controllersInternal;
        return controllers;
    }
}
