import { Module } from '@nestjs/common';
import { OAController } from './oa-controller';
import { OAService } from './oa-service';
import { EmailService } from 'src/integration/email-service';
import { OAControllerInternal } from './oa-controller-internal';
import { OAControllerOpen } from './oa-controller-open';
import { MembershipModule } from 'src/membership/membership-module';
import { UserEntity } from './user-entity';
import { TypeOrmModule } from '@nestjs/typeorm';
import { OAStorage } from './oa-storage';

@Module({
    imports: [MembershipModule, TypeOrmModule.forFeature([UserEntity])],
    controllers: OAModule.getControllers(),
    providers: [OAService, OAStorage, EmailService],
    exports: [OAService] // for direct use in stats
})
export class OAModule {
    static getControllers(): Array<any> {
        // add all the non-conditional controllers here
        const controllersInternal: Array<any> = [
            OAControllerInternal, // add all the controllers that are only for internal use
        ];
        const controllers: Array<any> = [
            OAController, OAControllerOpen // add all the controllers that are for external use
        ];
        if (process.env?.INTERNAL_API?.trim() === 'true')
            return controllersInternal;
        return controllers;
    }
}
