import { UserRole } from 'src/constants';
import { Column, Entity, Index, PrimaryColumn } from "typeorm";

@Entity('user')
export class UserEntity {

    @PrimaryColumn({ type: 'char', length: 22, nullable: false, update: false })
    uid: string;

    @Index("IDX_USER_INVITATION", { unique: true })
    @Column({ type: 'char', length: 22, nullable: false })
    iid: string;

    @Column({ type: 'datetime', nullable: false })
    inv: Date;

    @Column({type: 'char', length: 5, nullable: false })
    otp: string;

    @Column({type: 'int', default: 0, nullable: false })
    att: number;

    @Column({
        type: 'enum',
        enum: UserRole,
        default: UserRole.USR,
        nullable: false,
    })
    rol: UserRole;

    @Column({ type: 'char', length: 2, nullable: true })
    cnt?: string;

    @Column({ type: 'char', length: 22, nullable: true })
    aff?: string;

    @Column({ type: 'varchar', length: 22, nullable: true })
    nck?: string;

    @Column({ type: 'varchar', length: 40, nullable: true })
    fname?: string;

    @Column({ type: 'varchar', length: 40, nullable: false })
    lname: string;

    @Column({ type: 'varchar', length: 80, nullable: false })
    email: string;

    @Column({ type: 'varchar', length: 40, nullable: true })
    phone?: string;

    @Column({ type: 'datetime', nullable: true })
    onb?: Date;

    @Column({ type: 'datetime', nullable: true })
    ofb?: Date;
}
