import { Prop, Schema, SchemaFactory } from '@nestjs/mongoose';
import { HydratedDocument } from 'mongoose';

export type RequestDocument = HydratedDocument<RequestDb>;

@Schema()
export class RequestDb {
  @Prop()
  rid: string;

  @Prop()
  requestor: string;

  @Prop()
  payload: string;

  @Prop()
  timestamp: string;

  @Prop()
  status: string;

  @Prop()
  message: string;
}

export const RequestSchema = SchemaFactory.createForClass(RequestDb);
