import {
  BadRequestException,
  Controller,
  Get,
  Param,
  UseGuards,
} from '@nestjs/common';
import { RequestsService } from './requests-service';
import {
  ApiBearerAuth,
  ApiOperation,
  ApiResponse,
  ApiTags,
} from '@nestjs/swagger';
import { RequestStatus } from '../dtos/request-status';
import { AuthGuard } from 'src/auth/auth-guard';
import { RolesGuard } from 'src/auth/roles-guard';
import { Roles } from 'src/auth/roles-decorator';

export const PENDING = 'PENDING';
export const PROCESSED = 'PROCESSED';
export const EXPIRED = 'EXPIRED';
export const FAILED = 'FAILED';

@ApiBearerAuth()
@ApiTags('Request Management')
@Controller()
@UseGuards(AuthGuard, RolesGuard)
export class RequestsController {
  constructor(private readonly requestService: RequestsService) { }

  @ApiOperation({ summary: 'Check Request Status' })
  @ApiResponse({
    status: 200,
    description: 'The found record',
    type: RequestStatus,
  })
  @Get('/api/v1.0/requests/:rid')
  @Roles('user', 'operator', 'admin')
  @ApiOperation({ summary: 'Check Request Status' })
  async checkRequestStatus(@Param('rid') rid: string): Promise<RequestStatus> {
    try {
      const request = await this.requestService.retrieve(rid);
      if (request && Object.keys(request).length > 0) {
        const requestStatus = new RequestStatus();
        requestStatus.finalized = request.timestamp;
        requestStatus.status = request.status;
        requestStatus.message = request.message;

        return requestStatus;
      } else {
        throw new BadRequestException(
          `Request with this ${rid} does not exist`,
        );
      }
    } catch (error) {
      console.log('checkRequestStatus - error into retrieve: ', error);
      throw error;
    }
  }
}
