import { Module } from '@nestjs/common';
import { RequestsController } from './requests-controller';
import { RequestsService } from './requests-service';
import { RequestsInternalController } from './requests-controller-internal';

@Module({
  controllers: RequestsModule.getControllers(),
  providers: [RequestsService],
})
export class RequestsModule {
  static getControllers(): Array<any> {
    // add all the non-conditional controllers here
    const controllersInternal: Array<any> = [
      RequestsInternalController, // add all the controllers that are only for internal use
    ];
    const controllers: Array<any> = [
        RequestsController, // add all the controllers that are for external use
    ];
    if (process.env?.INTERNAL_API?.trim() === 'true') return controllersInternal;
    return controllers;
  }
}
