import { Controller, Get, HttpCode, UseGuards } from '@nestjs/common';
import { ApiBearerAuth, ApiOperation, ApiResponse, ApiTags } from '@nestjs/swagger';
import { AuthGuard } from 'src/auth/auth-guard';
import { StatsService } from './stats-service';
import { EcosystemStats } from 'src/dtos/ecosystem-stats';
import { HTTP_ERR_401, HTTP_ERR_500 } from 'src/constants';

@ApiTags('Open API: Ecosystem Stats')
@Controller('/api/v1.0/stats')
@ApiBearerAuth()
@UseGuards(AuthGuard)
export class StatsController {

    constructor(
        private readonly statsService: StatsService
    ) { }
    
    @Get()
    @HttpCode(200)
    @ApiOperation({
        summary: 'Retrieves some basic statistics of the FAME Ecosystem',
        description: `This operation provides a very generic overview of the current state of the FAME Ecosystem:
  number of active members, number of active trading accounts and number of active users onboarded by the FAME ROA.`
    })
    @ApiResponse({
        status: 200, // OK
        description: `Returns an object containing the desired ecosystem stats`,
        type: EcosystemStats
    })
    @ApiResponse({ status: 401, description: HTTP_ERR_401 })
    @ApiResponse({ status: 500, description: HTTP_ERR_500 })
    async getStats(): Promise<EcosystemStats> {
        return await this.statsService.getStats();
    }
}