import { Module } from '@nestjs/common';
import { StatsService } from './stats-service';
import { StatsController } from './stats-controller';
import { MembershipModule } from 'src/membership/membership-module';
import { OAModule } from 'src/oa/oa-module';

@Module({
    imports: [MembershipModule, OAModule],
    controllers: StatsModule.getControllers(),
    providers: [StatsService]
})
export class StatsModule {
    static getControllers(): Array<any> {
        
        // add all the non-conditional controllers here

        const controllersInternal: Array<any> = [
            // add all the controllers that are only for internal use
        ];

        const controllers: Array<any> = [
            // add all the controllers that are for external use
            StatsController
        ];

        if (process.env?.INTERNAL_API?.trim() === 'true')
            return controllersInternal;
        return controllers;
    }
}
