import { Injectable } from '@nestjs/common';
import { EntityStatus, UserStatus } from 'src/constants';
import { EcosystemStats } from 'src/dtos/ecosystem-stats';
import { OAService } from 'src/oa/oa-service';
import { MembershipService } from 'src/membership/membership-service';

@Injectable()
export class StatsService {

    constructor(
        private readonly membership: MembershipService,
        private readonly oa: OAService,
    ) { }

    async getStats(): Promise<EcosystemStats> {
        const stats = new EcosystemStats();
        stats.members = (await this.membership.listMembers({ sta: EntityStatus.ACTIVE })).length;
        stats.accounts = (await this.membership.listAccounts({ sta: EntityStatus.ACTIVE })).length;
        stats.localUsers = (await this.oa.listUser({ sta: UserStatus.ONBOARDED })).length;
        return stats;
    }
}