import { Module } from '@nestjs/common';
import { ConfigModule } from '@nestjs/config';
import { HttpModule, HttpService } from '@nestjs/axios';
import { PatController } from './controllers/pat.controller';
import { PatService } from './pats/services/pat.service';
import { PatModule } from './modules/pat.module';
import { PatOfferingRepository } from './pats/repositories/pat.offering-repository';
import { PatAnswersRepository } from './pats/repositories/pat.answers-repository';
import { MongodbController } from './controllers/mongodb.controller';
import { MongodbService } from './pats/services/mongodb.service';
import { SatModule } from './modules/sat.module';
import { MongodbModule } from './modules/mongodb.module';
import { SatController } from './controllers/sat.controller';
import { SatService } from './pats/services/sat.service';
import axios from 'axios';

@Module({
  imports: [
    ConfigModule.forRoot({
      envFilePath: '.env',
      isGlobal: true,
    }),
    PatModule,
    SatModule,
    MongodbModule,
    HttpModule, // Import HttpModule
  ],
  controllers: [PatController, MongodbController, SatController],
  providers: [
    PatService,
    PatOfferingRepository,
    PatAnswersRepository,
    MongodbService,
    SatService,
    HttpService,
    {
      provide: 'AXIOS_INSTANCE_TOKEN', // Provide the custom AXIOS_INSTANCE_TOKEN globally
      useValue: axios.create(), // Create a new Axios instance using axios.create()
    },
  ],
})
export class AppModule {}
