import {
  Body,
  Controller, Delete,
  Get, Param, Post,
  Query,
} from '@nestjs/common';

import { PatService } from '../pats/services/pat.service';
import { ApiBearerAuth, ApiOperation, ApiTags } from "@nestjs/swagger";
import { PatOfferingRepository } from '../pats/repositories/pat.offering-repository';
import { PatAnswersRepository } from '../pats/repositories/pat.answers-repository';
import { MongodbService } from '../pats/services/mongodb.service';
import {OfferingMain} from "../pats/entities/offering-main.dto";
import {QuestionnaireCompiled} from "../pats/entities/questionnaire-compiled.dto";

@ApiBearerAuth()
@ApiTags('TEST - MongoDB Queries')
@Controller()
export class MongodbController {
  constructor(
      private readonly mongoDbService : MongodbService,
      private readonly patService: PatService,
      private readonly patOfferingsRepository : PatOfferingRepository,
      private readonly patAnswersRepository : PatAnswersRepository
  ) {}

  /*
  @Get('/pat/v1.0/offering-by-id')
  @ApiOperation({ summary: 'OfferingById', description: 'Method for testing purposes - returns offering data from mongodb' })
  async offeringById(@Query('offeringId') id: string): Promise<String> {
    return this.mongoDbService.offeringById(id, this.patOfferingsRepository, this.patService);
  }

  @Get('/pat/v1.0/answer-by-offering-id')
  @ApiOperation({ summary: 'AnswerByOfferingId', description: 'Method for testing purposes - returns answers data from mongodb' })
  async answerByOfferingId(@Query('offeringId') id: string): Promise<String> {
    return this.mongoDbService.answerByOfferingId(id, this.patAnswersRepository, this.patService);
  }

  @Get('/pat/v1.0/offerings-by-dcterms-type')
  @ApiOperation({ summary: 'OfferingsByDctermsType', description: 'Fetch all offerings with a specific dcterms_type from MongoDB' })
  async offeringsByDctermsType(@Query('dctermsType') dctermsType: string): Promise<String[]> {
    return this.mongoDbService.offeringsByDctermsType(dctermsType, this.patOfferingsRepository, this.patService);
  }
  */

  @Get('/pat/v1.0/all-offerings')
  @ApiOperation({ summary: 'AllOfferings', description: 'Fetch all offerings from MongoDB' })
  async getAllOfferings(): Promise<OfferingMain[]> {
    return this.mongoDbService.getAllOfferings(this.patOfferingsRepository);
  }

  @Get('/pat/v1.0/all-answers')
  @ApiOperation({ summary: 'AllAnswers', description: 'Fetch all answers from MongoDB' })
  async getAllAnswers(): Promise<QuestionnaireCompiled[]> {
    return this.mongoDbService.getAllAnswers(this.patAnswersRepository);
  }

  @Delete('delete-all-offerings')
  async deleteAllOfferings() {
    console.log('Deleting all offerings');
    await this.patOfferingsRepository.deleteAllOfferings();
    return { message: 'All offerings deleted successfully' };
  }

  @Delete('delete-all-answers')
  async deleteAllAnswers() {
    console.log('Deleting all answers');
    await this.patAnswersRepository.deleteAllAnswers();
    return { message: 'All answers deleted successfully' };
  }

  /*

  @Delete('delete-offering/:id')
  async deleteOfferingById(@Param('id') id: string) {
    console.log(`Deleting offering with id: ${id}`);
    await this.patOfferingsRepository.deleteOfferingById(id);
    return { message: `Offering with id ${id} deleted successfully` };
  }

  @Delete('delete-answers-by-offering/:id')
  async deleteAnswersByOfferingId(@Param('id') id: string) {
    console.log(`Deleting answers for offering with id: ${id}`);
    await this.patAnswersRepository.deleteAnswersByOfferingId(id);
    return { message: `Answers for offering with id ${id} deleted successfully` };
  }

  @Post('/import-offerings')
  @ApiOperation({ summary: 'Import Offerings', description: 'Import one or more offerings into MongoDB' })
  async importOfferings(@Body() offerings: OfferingMain | OfferingMain[]): Promise<string> {
    // Ensure offerings is an array
    const offeringsArray = Array.isArray(offerings) ? offerings : [offerings];

    const results = await Promise.all(
        offeringsArray.map(async (offering) => {
          const success = await this.patOfferingsRepository.saveOffering(offering);
          return success;
        })
    );

    return `Successfully imported ${results.length} offerings`;
  }
  */
}
