import { Controller, Get, Query } from '@nestjs/common';
import { ApiBearerAuth, ApiOperation, ApiTags } from '@nestjs/swagger';
import { SatService } from '../pats/services/sat.service';

@ApiBearerAuth()
@ApiTags('Similarity Analysis Tool - SAT')
@Controller()
export class SatController {
    constructor(private readonly satService: SatService) {}

    @Get('/sat/v1.0/find-similar-offerings')
    @ApiOperation({
        summary: 'SBERT similarity tool',
        description:
            'Find similar offerings based on the provided offering using SBERT similarity analysis and MongoDB.',
    })
    async findSimilarOfferings(
        @Query('offeringId') offeringId: string,
        @Query('threshold') threshold?: string
    ) {
        if (!offeringId) {
            throw new Error('offeringId parameter is required.');
        }

        const thresholdValue = threshold !== undefined ? parseFloat(threshold) : undefined;
        if (threshold !== undefined && (isNaN(thresholdValue) || thresholdValue < 0 || thresholdValue > 1)) {
            throw new Error('Threshold must be a number between 0 and 1.');
        }

        return await this.satService.findSimilarOfferingsForOfferingId(offeringId, thresholdValue);
    }

}
