import { Module } from '@nestjs/common';
import { PatOfferingRepository } from '../pats/repositories/pat.offering-repository';
import { PatAnswersRepository } from '../pats/repositories/pat.answers-repository';
import { MongodbController } from '../controllers/mongodb.controller';
import { MongodbService } from '../pats/services/mongodb.service';
import { PatService } from '../pats/services/pat.service';
import { HttpModule, HttpService } from '@nestjs/axios';
import axios from 'axios';

@Module({
    imports: [HttpModule],
    controllers: [MongodbController],
    providers: [
        MongodbService,
        PatOfferingRepository,
        PatAnswersRepository,
        PatService,
        HttpService,
        {
            provide: 'AXIOS_INSTANCE_TOKEN', // Define the custom provider
            useValue: axios.create(), // Create an Axios instance
        },
    ],
})
export class MongodbModule {}
