import { Module } from '@nestjs/common';
import { SatController } from '../controllers/sat.controller';
import { SatService } from '../pats/services/sat.service';
import { HttpModule, HttpService } from '@nestjs/axios';
import { MongodbService } from '../pats/services/mongodb.service';
import { PatOfferingRepository } from '../pats/repositories/pat.offering-repository';
import { PatAnswersRepository } from '../pats/repositories/pat.answers-repository';
import axios from 'axios';

@Module({
    imports: [HttpModule],
    controllers: [SatController],
    providers: [
        SatService,
        MongodbService,
        PatOfferingRepository,
        PatAnswersRepository,
        HttpService,
        {
            provide: 'AXIOS_INSTANCE_TOKEN', // This is the custom provider
            useValue: axios.create(), // Create an Axios instance
        },
    ],
})
export class SatModule {}
