import {CanActivate, ExecutionContext, ForbiddenException, Injectable, UnauthorizedException,} from '@nestjs/common';
import {JwtService} from '@nestjs/jwt';
import {Request} from 'express';

@Injectable()
export class AuthGuard implements CanActivate {
    constructor(private jwtService: JwtService) {
    }

    async canActivate(context: ExecutionContext): Promise<boolean> {
        const request = context.switchToHttp().getRequest();
        const token = this.extractTokenFromHeader(request);
        if (!token) {
            throw new UnauthorizedException();
        }
        const decodedObj = this.jwtService.decode(token);
        if (decodedObj && decodedObj.sub) {
            console.log("Auth Guard: Pid found --> " + decodedObj.sub)
            //TODO Lookup pid from token
            return true;
        } else
            throw new ForbiddenException();
    }

    private extractTokenFromHeader(request: Request): string | undefined {
        const [type, token] = request.headers.authorization?.split(' ') ?? [];
        return type === 'Bearer' && token ? token : undefined;
    }
}