import { Offering } from './offering.dto';

export enum DcTermsType {
  DATASET = 'DATASET',
  DIGITAL_PRODUCT = 'DIGITAL_PRODUCT'
}

export function mapDcTermsType(assetType: string): DcTermsType {
  return assetType === "Dataset" ? DcTermsType.DATASET : DcTermsType.DIGITAL_PRODUCT;
}

export class OfferingMain {
  offering_id: string; // offering ID
  cid: string; // correlation ID
  dcterms_identifier: string; // asset ID
  dcterms_type: string; // asset type
  dcterms_title: string; // asset title
  dcterms_description: string; // asset description
  offering?: Offering; // business model information
  advised_price: Number; // asset price advised by PAT
  created: Date;
}
