import { Option } from './option.dto';
import { Exclude } from 'class-transformer';
import { Limit } from './limit.dto';
import { ApiProperty } from '@nestjs/swagger';

export class Question {
  @Exclude()
  alias?: string;

  @ApiProperty({ example: 1 })
  id: number;

  @ApiProperty({ example: true })
  required: boolean;

  @ApiProperty({ example: 'BOOLEAN' })
  type: string;

  @ApiProperty({ example: 1 })
  group: number;

  @Exclude()
  weight?: string;

  @ApiProperty({ example: 'Is this a sample question?' })
  label?: string;

  @ApiProperty({ type: [Option], example: [{ label: 'Yes', value: 1 }, { label: 'No', value: 0 }] })
  options?: Option[];

  @ApiProperty({ type: Limit, example: { min: 1, max: 10 } })
  limits?: Limit;
}
