import {Question} from './question.dto';
import { ApiProperty } from '@nestjs/swagger';

export class Questionnaire {
  @ApiProperty({example : "62501209d0918e95edfb80cd749fe048"})
  cid: string = null;

  @ApiProperty({
    type: [Question],
    example: [
      {
        id: 1,
        required: true,
        type: 'BOOLEAN',
        group: 1,
        label: 'Is this a sample question?',
        options: [
          { label: 'Yes', value: 1 },
          { label: 'No', value: 0 }
        ]
      },
      {
        id: 2,
        required: true,
        type: 'NUMERIC',
        group: 2,
        label: 'Is this a sample question?',
        limits: {
          min: 0
        }
      },
      {
        id: 3,
        required: true,
        type: 'SELECT',
        group: 2,
        label: 'Is the dataset unique/original?',
        options: [
          { label: 'generic', value: 1 },
          { label: 'some', value: 2 },
          { label: 'average', value: 3 }
        ]
      }
    ]
  })
  questions: Question[] = [];

  findQuestionById(id: number): Question | undefined {
    return this.questions.find(question => question.id === id);
  }
}


