# Automated RPC Node Restart Setup

This guide explains how to set up automated daily restarts of your Besu RPC node container.

## Prerequisites

- Root or sudo access on your Linux server
- Docker installed and running
- Knowledge of your RPC container name

## Setup Instructions

### 1. Find Your RPC Container Name

First, identify the exact name of your RPC node container:

```bash
docker ps --format '{{.Names}}'
```

Look for the container running the RPC service. Common names in Besu Quickstart:
- `besu-rpcnode-1`
- `rpcnode`
- `besu-node-rpc`

### 2. Transfer and Configure the Script

Copy `restart-rpc-node.sh` to your Linux server:

```bash
# From your local machine (Windows), transfer to server
scp restart-rpc-node.sh user@your-server:/opt/besu/restart-rpc-node.sh
```

On the Linux server, edit the script to set your container name:

```bash
# Edit the script
sudo nano /opt/besu/restart-rpc-node.sh

# Update this line with your actual container name:
RPC_CONTAINER_NAME="besu-rpcnode-1"  # Change this to match your container
```

### 3. Make the Script Executable

```bash
sudo chmod +x /opt/besu/restart-rpc-node.sh
```

### 4. Create the Log Directory

```bash
sudo mkdir -p /var/log
sudo touch /var/log/besu-rpc-restart.log
```

### 5. Test the Script Manually

Before scheduling, test that it works:

```bash
sudo /opt/besu/restart-rpc-node.sh
```

Check the log output:

```bash
sudo tail -f /var/log/besu-rpc-restart.log
```

### 6. Set Up the Cron Job

Edit the root crontab (since Docker commands typically require root):

```bash
sudo crontab -e
```

Add this line to restart the RPC node daily at 3:00 AM UTC:

```cron
0 3 * * * /opt/besu/restart-rpc-node.sh
```

**Cron syntax explanation:**
- `0` - minute (0)
- `3` - hour (3 AM)
- `*` - day of month (every day)
- `*` - month (every month)
- `*` - day of week (every day)

### 7. Verify the Cron Job

List all cron jobs to verify it was added:

```bash
sudo crontab -l
```

## Alternative: Using systemd Timer (Optional)

If you prefer systemd over cron, you can create a timer instead:

### Create the service file:

```bash
sudo nano /etc/systemd/system/besu-rpc-restart.service
```

Content:
```ini
[Unit]
Description=Restart Besu RPC Node Container
After=docker.service

[Service]
Type=oneshot
ExecStart=/opt/besu/restart-rpc-node.sh
```

### Create the timer file:

```bash
sudo nano /etc/systemd/system/besu-rpc-restart.timer
```

Content:
```ini
[Unit]
Description=Daily restart of Besu RPC node at 3 AM UTC

[Timer]
OnCalendar=*-*-* 03:00:00
Persistent=true

[Install]
WantedBy=timers.target
```

### Enable and start the timer:

```bash
sudo systemctl daemon-reload
sudo systemctl enable besu-rpc-restart.timer
sudo systemctl start besu-rpc-restart.timer
```

### Check timer status:

```bash
sudo systemctl status besu-rpc-restart.timer
sudo systemctl list-timers --all
```

## Monitoring and Troubleshooting

### View restart logs:

```bash
# View recent logs
sudo tail -n 50 /var/log/besu-rpc-restart.log

# Follow logs in real-time
sudo tail -f /var/log/besu-rpc-restart.log

# View logs for a specific date
sudo grep "2025-11-19" /var/log/besu-rpc-restart.log
```

### Check if cron is running:

```bash
sudo systemctl status cron
```

### Test different restart times:

To test at a different time, modify the cron schedule. For example, to run every hour:
```cron
0 * * * * /opt/besu/restart-rpc-node.sh
```

### Log rotation (recommended):

Create a logrotate configuration to prevent the log file from growing too large:

```bash
sudo nano /etc/logrotate.d/besu-rpc-restart
```

Content:
```
/var/log/besu-rpc-restart.log {
    daily
    rotate 30
    compress
    delaycompress
    notifempty
    missingok
    create 0644 root root
}
```

## Timezone Considerations

The cron daemon typically runs in the system's timezone. To ensure the restart happens at 3 AM UTC:

1. Check your server's timezone:
```bash
timedatectl
```

2. If your server is NOT in UTC, either:
   - Set the server to UTC: `sudo timedatectl set-timezone UTC`
   - Or adjust the cron time to match UTC (e.g., if server is EST, use 22:00 previous day)

## Important Notes

- The restart will cause brief downtime for RPC clients
- Ensure your application can handle RPC node restarts gracefully
- The script logs all operations for audit purposes
- Consider notifying users about the maintenance window
- Monitor the logs regularly to ensure restarts are successful

## Removing the Automated Restart

If you need to disable the automated restart:

```bash
# For cron
sudo crontab -e
# Remove or comment out the line with restart-rpc-node.sh

# For systemd timer
sudo systemctl stop besu-rpc-restart.timer
sudo systemctl disable besu-rpc-restart.timer
```
