import {Module} from '@nestjs/common';
import {AssetModule} from './assets/asset-module';
import {ConfigModule} from "@nestjs/config";
import {IntegrationModule} from "./integration/integration-module";
import {MongooseModule} from "@nestjs/mongoose";
import {OfferingModule} from "./offerings/offering-module";
import {SourceModule} from './sources/source-module';
import { PermissionModule } from './permissions/permission-module';
import { StatsModule } from './stats/stats-module';

@Module({
    imports: [
        ConfigModule.forRoot({
            envFilePath: '.env',
            isGlobal: true,
        }),
        MongooseModule.forRoot(process.env.DATABASE_URI, {
            dbName: process.env.DATABASE_NAME,
            authSource: process.env.DATABASE_AUTH_SOURCE,
        }),
        SourceModule,
        AssetModule,
        OfferingModule,
        StatsModule,
        PermissionModule,
        IntegrationModule,
    ],
})
export class AppModule {
}
