import { Module } from '@nestjs/common';
import { AssetController } from './asset-controller';
import { AssetService } from './asset-service';
import { IntegrationModule } from "../integration/integration-module";
import { SourceModule } from 'src/sources/source-module';
import { OfferingModule } from '../offerings/offering-module';
import { AssetRepublishJobState } from './asset-republish-job-state';

@Module({
    imports: [IntegrationModule, SourceModule, OfferingModule],
    controllers: AssetModule.getControllers(),
    providers: [AssetService, AssetRepublishJobState],
})
export class AssetModule {
    static getControllers(): Array<any> {
        if (process.env?.INTERNAL_API?.trim() === 'true') return [];
        else return [AssetController];
    }
}
