// these are the maximum lenghts of the fields in DTOs that may contain user-provided input
export const ID_MAXL: number = 60; // generic, permissive rule for system-generated IDs of unknonw length
export const SHORTID_MAXL: number = 22;
export const HALF_LINER_MAXL: number = 40;
export const ONE_LINER_MAXL: number = 80;
export const TWO_LINER_MAXL: number = 160;
export const TEXTCOL_MAXL = 255;
export const TXT_SHORT_MAXL: number = 500;
export const TXT_LONG_MAXL: number = 5000;
export const DOCUMENT_MAXL: number = 30000;
export const PRICE_MAX: number = 1000000;
export const FAME_PFX: string = 'fame_man_id:';
export const HTTP_ERR_400: string = 'Bad Request: missing or invalid input data';
export const HTTP_ERR_401: string = 'Unauthorized: missing or invalid authentication';
export const HTTP_ERR_403: string = 'Forbidden: access denied due to policy';
export const HTTP_ERR_404: string = 'Not Found: the target resource does not exist or is in invalid state';
export const HTTP_ERR_500: string = 'Internal Server Error: something went wrong, the operation failed';
export const HTTP_ERR_502: string = 'Bad Gateway: an upstream server was unable to process this request';

// "as const" helps TypeScript treat these as literal types
export const PERIOD_DENOMS = ['m', 'H', 'D', 'M', 'Y'] as const;
export const PERIOD_MILLISECS = [60000, 3600000, 86400000, 2592000000, 31104000000] as const; // must be synched with PERIOD_DENOMS

export enum EntityStatus {
    A = "A", // Active
    I = "I", // Inactive (revertable status, when supported; when not, it's equivalent to D)
    D = "D", // Disabled (permanent status, when status reversal is supported: when not, it's equivalent to I)
}

export enum BusinessModel {
    SUB = 'SUB', // Time-based subscription
    PAYU = 'PAYU', // Pay upfront for a package of individual accesses
    PAYG = 'PAYG', // Pay for the actual usage (e.g., per GB of data downloaded/processed, etc.)
    FREE = 'FREE', // No payment required, free of charge
}

export enum AssetType {
    DATA = 'DATA',
    MODEL = 'MODEL',
    DOCUMENT = 'DOCUMENT',
    APPLICATION = 'APPLICATION',
    SERVICE = 'SERVICE',
    WEBAPP = 'WEBAPP',
    CLIENT = 'CLIENT',
    LIBRARY = 'LIBRARY',
}

export const AssetCatalogueTypes = [
    'Dataset',
    'Model',
    'Documentation', 
    'Application', 
    'Web - API', 
    'Web-based tool', 
    'Client', 
    'Library' 
] as const;
