import {ApiProperty} from "@nestjs/swagger";
import { IsEthereumAddress, IsNotEmpty } from 'class-validator';

export class AccountIdentifier {

    constructor(tid: string) {
        this.tid = tid;
    }

    @ApiProperty({
        description: 'Address of the Ethereum account to be enrolled or disenrolled (REQUIRED)',
        example: '0x42eA4063fC0D1E9276c54e1C2cC7EE6d5616b67f',
    })
    @IsNotEmpty()
    @IsEthereumAddress()
    tid : string;
}

