import { ApiProperty } from '@nestjs/swagger';

export class AssetHashingTrxInput {

    @ApiProperty({
        description: 'AID of trusted asset',
    })
    aid: string;

    @ApiProperty({
        description: 'Hash value of asset catalogue entry',
    })
    hash: string;

    @ApiProperty({
        description: 'Tracing Ledger contract address',
    })
    addr: string;

    
    @ApiProperty({
        description: 'Tracing Ledger contract interface specs',
    })
    abi: string;

    @ApiProperty({
        description: 'Smart contract function name to call',
    })
    functionName: string;

    @ApiProperty({
        description: 'AID of the predecessor asset (for lineage tracking, optional)',
        required: false,
    })
    predecessorAid?: string;
}
