import { ApiProperty, ApiPropertyOptional } from '@nestjs/swagger';

export class AssetMetadata {

    @ApiProperty({
        description: 'Asset identifier (AID)',
    })
    aid: string;

    @ApiProperty({
        description: 'Asset catalogue entry (JSON object)',
    })
    entry: any;

    @ApiProperty({
        description: 'Hash value of the asset catalogue entry, as stored in the TracingLadger',
    })
    hash: string;

    @ApiProperty({
        description: 'TID of publisher (enrolled trading account)',
    })
    tid: string;

    @ApiProperty({
        description: 'Timestamp of asset publishing (ISO8601)',
    })
    registered: string;

    @ApiProperty({
        description: 'Catalogue entry verification status',
    })
    trustworthy: boolean;

    @ApiPropertyOptional({
        description: 'Comma-separated list of predecessor asset identifiers',
        required: false,
    })
    lineage?: string;
}