import { ApiProperty } from '@nestjs/swagger';

export class AssetTracingRecord {

    @ApiProperty({
        description: 'AID of trusted asset',
    })
    aid: string;

    @ApiProperty({
        description: 'TID of publisher (enrolled trading account)',
    })
    tid: string;

    @ApiProperty({
        description: 'Timestamp of asset publishing (ISO8601)',
    })
    pub: string;

    @ApiProperty({
        description: 'Timestamp of last change to asset catalogue entry (ISO8601)',
    })
    mod: string;

    @ApiProperty({
        description: 'Hash value of catalogue entry',
    })
    hash: string;

    @ApiProperty({
        description: 'Asset publishing status',
    })
    published: boolean;
}
