import { ApiProperty } from "@nestjs/swagger";
import { IsNotEmpty, IsString } from 'class-validator';

export class Identifier {

    constructor(id: string | null) {
        this.id = id;
    }

    @ApiProperty({
        description: 'Unique identifier (REQUIRED)',
    })
    @IsNotEmpty()
    @IsString()
    id: string | null;
}