import { ApiProperty } from '@nestjs/swagger';
import { ArrayMinSize, IsArray, IsString } from 'class-validator';

export class Identifiers {

    @ApiProperty({
        description: 'Array of string-based identifiers',
        type: [String],
        example: ['id1', 'id2', 'id3']
    })
    @IsArray()
    @ArrayMinSize(1)
    @IsString({ each: true })
    ids: string[];
}
