import { ApiProperty } from '@nestjs/swagger';
import { OfferingDescriptor } from './offering-descriptor';

export class OfferingRecord {
    @ApiProperty({
        description: 'OID of the offering',
    })
    oid: string;

    @ApiProperty({
        description: 'Offering descriptor with all offering details',
        type: OfferingDescriptor,
    })
    offering: OfferingDescriptor;

    @ApiProperty({
        description: 'Status of the offering (DRAFT, ACTIVE, ARCHIVED)',
        enum: ['DRAFT', 'ACTIVE', 'ARCHIVED'],
    })
    status: string;
}