import { ApiProperty } from '@nestjs/swagger';
import { BusinessModel } from 'src/constants';

export class OfferingReference {

    @ApiProperty({
        description: 'Asset id (AID) of the linked asset'
    })
    aid: string;

    @ApiProperty({
        description: 'Offering id (OID)'
    })
    oid: string;

    @ApiProperty({
        description: 'Offering title'
    })
    title: string;

    @ApiProperty({
        description: 'Offering price'
    })
    price: string;

    @ApiProperty({
        description: `Business model (Accepted values: [${Object.values(BusinessModel).join(', ')}])`,
    })
    model: BusinessModel;
}