import { ApiProperty, ApiPropertyOptional } from "@nestjs/swagger";
import { LegalEntity } from "./legal-entity";
import { IsNotEmpty, ValidateNested, IsOptional, Length, IsString, IsAlphanumeric } from 'class-validator';
import { Type } from 'class-transformer';
import { SHORTID_MAXL } from '../constants';

export class Source {

    @ApiProperty({
        description: 'PID of trusted source (REQUIRED, 22-characters short UUID)',
        example: 'w5xQXA2f22UEzLGf9z9Zio',
    })
    @IsAlphanumeric()
    @Length(SHORTID_MAXL, SHORTID_MAXL)
    pid: string;

    @ApiProperty({
        description: 'Contact information of legal entity (REQUIRED)',
    })
    @IsNotEmpty()
    @ValidateNested()
    @Type(() => LegalEntity)
    descriptor: LegalEntity;

    @ApiPropertyOptional({
        description: 'ISO8601 timestamp of onboarding (IGNORED in input)',
    })
    @IsOptional()
    in?: string;

    @ApiPropertyOptional({
        description: 'ISO8601 timestamp of offboarding (IGNORED in input)',
    })
    @IsOptional()
    out?: string;
}