import { Injectable } from "@nestjs/common";
import { AssetDescriptor } from "../dtos/asset-descriptor";
import axios from "axios";
import { ConfigService } from "@nestjs/config";

@Injectable()
export class FdacService {
    private readonly url: string;
    private readonly pubToken: string
    private readonly certToken: string

    constructor(private readonly configService: ConfigService) {
        this.url = this.configService.get<string>('FDAC_URL');
        this.pubToken = this.configService.get<string>('FDAC_PUB_TOKEN');
        this.certToken = this.configService.get<string>('FDAC_CERT_TOKEN');
    }

    public async createEntry(asset: AssetDescriptor): Promise<string> {
        const config = {
            params: {
                createNewEntity: true
            },
            headers: {
                Authorization: `Bearer ${(this.pubToken)}`,
                'Content-Type': 'application/json',
            }
        };
        const { data } = await axios.post(`${this.url}/interoperability/dcat/components`, asset, config);
        return data;
    }

    public async getAssetCanonicalDescription(aid: string): Promise<string> {
        const config = {
            headers: {
                Authorization: `Bearer ${(this.pubToken)}`
            }
        };
        try {
            const { data } = await axios.get(`${this.url}/interoperability/canonical/components/${aid}`, config);
            return data;
        } catch (err) {
            if (err.response && err.response.status === 404) {
                return null;
            } else {
                throw err;
            }
        }
    }

    public async getAssetDcatDescription(aid: string): Promise<string> {
        const config = {
            headers: {
                Authorization: `Bearer ${(this.pubToken)}`
            }
        };
        try {
            const { data } = await axios.get(`${this.url}/interoperability/dcat/components/${aid}`, config);
            return data;
        } catch (err) {
            if (err.response && err.response.status === 404) {
                return null;
            } else {
                throw err;
            }
        }
    }

    public async certifyEntry(aid: string): Promise<string> {
        const config = {
            headers: {
                Authorization: `Bearer ${(this.certToken)}`
            }
        };
        const { data } = await axios.post(`${this.url}/data/components/${aid}/certificate`, {}, config);
        return data;
    }

    public async archiveEntry(aid: string): Promise<string> {
        // TODO implement this
        return null;
    }}
