import { Injectable, Logger } from "@nestjs/common";
import axios from "axios";
import { ConfigService } from "@nestjs/config";

@Injectable()
export class PatService {
    private readonly url: string;

    constructor(private readonly configService: ConfigService) {
        this.url = this.configService.get<string>('PAT_URL');
    }

    public async sendConfirmation(id: string, offering: string): Promise<void> {
        try {
            const requestBody = {
                id: id,
                offering: offering
            };

            const config = {
                headers: {
                    'Content-Type': 'application/json',
                }
            };

            await axios.post(this.url + '/confirmation', requestBody, config);
        } catch (error) {
            Logger.error('Unexpected error in PatService.sendConfirmation: ', error.message);
            throw error;
        }
    }
}