import {Injectable, Logger} from "@nestjs/common";
import axios from "axios";
import {ConfigService} from "@nestjs/config";
import {TradingInfo} from "../dtos/trading-info";

// TODO move this service to the common module
@Injectable()
export class TmService {
    private readonly url: string;

    constructor(private readonly configService: ConfigService) {
        this.url = this.configService.get<string>('TM_URL');
    }

    public async setupTrading(tradingSetupInfo: TradingInfo): Promise<string> {
        try {
            const config = {
                headers: {
                    'Content-Type': 'application/json',
                    Accept: '*/*',
                }
            };
            const {data} = await axios.post(this.url + '/offerings', tradingSetupInfo, config);
            return data;
        } catch (error) {
            Logger.error('Unexpected error in TmService.setupTrading: ', error.message);
            throw error;
        }
    }

    public async disableTrading(oid: string): Promise<void> {
        try {
            await axios.delete(this.url + '/offerings/' + oid);
        } catch (error) {
            Logger.error('Unexpected error in TmService.disableTrading: ', error.message);
            throw error;
        }
    }
}
