import { Module } from "@nestjs/common";
import { OfferingController } from "./offering-controller";
import { OfferingService } from "./offering-service";
import { IntegrationModule } from "../integration/integration-module";
import { OfferingCatalogue } from "./offering-catalogue";
import { OfferingControllerInternal } from "./offering-controller-internal";
import { SourceModule } from 'src/sources/source-module';

@Module({
  imports: [IntegrationModule, SourceModule],
  controllers: OfferingModule.getControllers(),
  providers: [OfferingService, OfferingCatalogue],
  exports: [
    OfferingService,
    OfferingCatalogue,
    IntegrationModule // Re-export IntegrationModule services, to avoid dependency injectio issues in other modules
  ]
})
export class OfferingModule {
  static getControllers(): Array<any> {
    if (process.env?.INTERNAL_API?.trim() === 'true') return [OfferingControllerInternal];
    else return [OfferingController];
  }
}
