import { Module } from "@nestjs/common";
import { PermissionControllerInternal } from "./permission-controller-internal";
import { PermissionService } from "./permission-service";
import { IntegrationModule } from "src/integration/integration-module";
import { PermissionController } from './permission-controller';

@Module({
    imports: [IntegrationModule],
    controllers: PermissionModule.getControllers(),
    providers: [PermissionService],
})
export class PermissionModule {
    static getControllers(): Array<any> {
        if (process.env?.INTERNAL_API?.trim() === 'true') return [PermissionControllerInternal];
        else return [PermissionController];
    }
}