import { Module } from '@nestjs/common';
import { SourceController } from "./source-controller";
import { SourceService } from "./source-service";
import { IntegrationModule } from 'src/integration/integration-module';
import { SourceControllerInternal } from './source-controller-internal';
import { SourceControllerOpen } from './source-controller-open';

@Module({
  imports: [IntegrationModule],
  controllers: SourceModule.getControllers(),
  providers: [SourceService],
  exports: [SourceService],
})
export class SourceModule {
  static getControllers(): Array<any> {
    if (process.env?.INTERNAL_API?.trim() === 'true') return [SourceControllerInternal];
    else return [SourceController, SourceControllerOpen];
  }
}
