import { Controller, Get, HttpCode, Post } from '@nestjs/common';
import { ApiOperation, ApiResponse, ApiTags } from '@nestjs/swagger';
import { StatsService } from './stats-service';
import { HTTP_ERR_500 } from 'src/constants';
import { BlockchainStats } from 'src/dtos/blockchain-stats';

@ApiTags('Internal API: Blockchain Stats')
@Controller('/pt/v1.0')
export class StatsControllerInternal {

    constructor(
        private readonly statsService: StatsService
    ) { }
    
    @Get('/blockchain/stats')
    @HttpCode(200)  
    @ApiOperation({
        summary: 'Retrieves the health status of the FAME Blockchain network',       
        description: `This operation provides the current health status of the connection to the FAME Blockchain network.`
    })
    @ApiResponse({
        status: 200, // OK
        description: `Returns an object containing the desired blockchain health status`,
        type: BlockchainStats
    })
    @ApiResponse({ status: 500, description: HTTP_ERR_500 })    
    getBlockchainStats(): BlockchainStats {
        return this.statsService.getBlockchainStats();
    }

    @Post('/blockchain/reconnect')
    @HttpCode(204)  
    @ApiOperation({
        summary: 'Reconnects to the FAME Blockchain network',
        description: `This operation forces the PT service to re-establish its connection with the FAME Blockchain network.`
    })
    @ApiResponse({ 
        status: 204, // No Content
        description: 'Reconnection initiated'
    })
    @ApiResponse({ status: 500, description: HTTP_ERR_500 })    
    async forceReconnect(): Promise<void> {
        await this.statsService.forceBlockchainReconnect();
    }
}