import { Module } from '@nestjs/common';
import { StatsService } from './stats-service';
import { StatsController } from './stats-controller';
import { OfferingModule } from 'src/offerings/offering-module';
import { StatsControllerInternal } from './stats-controller-internal';

@Module({
    imports: [OfferingModule], // Only import OfferingModule, which already exports IntegrationModule
    controllers: StatsModule.getControllers(),
    providers: [StatsService],
})
export class StatsModule {
    static getControllers(): Array<any> {
        
        // add all the non-conditional controllers here

        const controllersInternal: Array<any> = [
            StatsControllerInternal
        ];

        const controllers: Array<any> = [
            // add all the controllers that are for external use
            StatsController
        ];

        if (process.env?.INTERNAL_API?.trim() === 'true')
            return controllersInternal;
        return controllers;
    }
}
