import { Injectable } from '@nestjs/common';
import { BlockchainStats } from 'src/dtos/blockchain-stats';
import { CatalogueStats } from 'src/dtos/catalogue-stats';
import { BlockchainService } from 'src/integration/blockchain-service';
import { OfferingCatalogue } from 'src/offerings/offering-catalogue';

@Injectable()
export class StatsService {

    constructor(
        private readonly ocat: OfferingCatalogue,
        private readonly blockchain: BlockchainService
    ) { }

    async getCatalogueStats(): Promise<CatalogueStats> {
        const stats = new CatalogueStats();
        stats.offerings = await this.ocat.countActive();
        return stats;
    }

    getBlockchainStats(): BlockchainStats {
        return this.blockchain.getStats();
    }

    async forceBlockchainReconnect(): Promise<void> {
        await this.blockchain.forceReconnect();
    }
}