import {createApp} from 'vue'
import App from './App.vue'
import {createPinia} from "pinia";
import {router} from "@/router";
import PrimeVue from 'primevue/config';

import "bootstrap";
import "bootstrap/dist/css/bootstrap.min.css";

import "@/assets/css/app.css";

import "primevue/resources/themes/lara-light-blue/theme.css";
import "primevue/resources/primevue.min.css";
import "primeicons/primeicons.css";

import Card from 'primevue/card';
import IconField from 'primevue/iconfield';
import InputIcon from 'primevue/inputicon';
import Slider from 'primevue/slider';
import Dropdown from 'primevue/dropdown';
import InputText from 'primevue/inputtext';
import Knob from 'primevue/knob';
import Button from 'primevue/button';
import DataView from 'primevue/dataview';

const pinia = createPinia();

const app = createApp(App);

app.use(pinia);
app.use(router);
app.use(PrimeVue);

app.component('InputText', InputText)
  .component('Button', Button)
  .component('DataView', DataView)
  .component('Card', Card)
  .component('Dropdown', Dropdown)
  .component('Slider', Slider)
  .component('InputIcon', InputIcon)
  .component('Knob', Knob)
  .component('IconField', IconField);

app.mount('#app')
